﻿<?LassoScript

	// Invoice demo for Lasso Summit 2007
	// Author Jolle Carlestam
	// Use and alter freely but please keep this info




	// Preparation of demo content. This should be replaced with your
	// own record content handling.
	// the demo assumes that the files ex_cont/Invoice1.incl,
	// jina_prepPDF_demo.incl and ex_cont/invoice_base.pdf
	// are in the same folder and can be accessed by Lasso.
	Include:'ex_cont/jina_prepPDF_demo.incl';
	var:'invoiceDataFile' = (!(action_param:'invData') ? ('Invoice1.incl') | (action_param:'invData'));
	var:'invoiceData' = jina_prepDemoContent: (Include:'ex_cont/' + $invoiceDataFile);



	//#####################################################################//
	// Settings that control the look and layout of the invoice pages.
	// These demo settings are suitable for an A4 page.

	// These variables set the font face and leading.
	var:'plainFont' = (pdf_font: -face = 'Times-Roman', -size = 12, -color = '#000000');
	var:'boldFont' = (pdf_font: -face = 'Times-Bold', -size = 12, -color = '#000000');
	
	var:'BkgPDF' = 'ex_cont/invoice_base.pdf';

	var:'headingLeading' = 16;
	var:'textLeading' = 13;

	var:'pageSize' = 'A4';
	var:'pageHeight' = 842;
	var:'pageWidth' = 595;

	var:'marginLeft' = 60;

	// The top and left positions for objects used in the invoice, in points.
	var:'itemTop' = 252;
	var:'itemTopcont' = 110;
	var:'itemLeft' = 60;
	var:'datePos' = (array: 107,81,100,30); //left, top, width and height
	var:'refPos' = (array: 236,81,200,30);
	var:'invNoPos' = (array: 480,81,50,30);
	var:'buyerPos' = (array: 60,110,240,120);
	var:'supplierPos' = (array: 313,110,240,120);
	var:'sumPos' = (array: 402,630,150,30);
	var:'vatPos' = (array: 402,648,150,30);
	var:'totalPos' = (array: 402,665,150,30);
	var:'notePos' = (array: 60,630,290,120);
	var:'pageNoPos' = (array: 361,81,50,30);

	// Space available for item rows
	var:'verSpace' = 376;
	var:'verSpaceCont' = 600;
	var:'spaceBetween' = 8;

	// Starting point for horizontal divider line
	var:'lineStart' = 587;
	var:'lineStartCont' = 730;


	// The left and width of each column.
	var:'col1Left' = 0; //Relative to the page left margin.
	var:'col1Width' = 270;
	
	var:'col2Left' = 295; //Relative to the page left margin.
	var:'col2Width' = 33;

	var:'col3Left' = 333; //Relative to the page left margin.
	var:'col3Width' = 75;

	var:'col4Left' = 420; //Relative to the page left margin.
	var:'col4Width' = 75;

	// Setting a default country that will not show up in address fields 
	// in the invoice. All other countries will.
	var:'defaultCountry' = 'USA';

	//#####################################################################//
	// Vars set to be used by the application. Do not change these.
	var:'itemRow' = integer;
	var:'presentTopPos' = $verSpace;
	var:'itemRaw' = array;
	var:'itemTextContainer' = array;
	var:'itemVerSize' = integer;
	var:'tempContainer' = string;
	var:'itemText' = null;

	
	// Create the PDF file.
	var:'pdfTemplate' = (pdf_doc:
		-nocompress,
		-size = $pageSize,
		-title = 'invoice',
		-author = 'jinaOnline',
		-margins = (array: 0,0,0,0)
		);

	// Insert the background pdf page.
	$pdfTemplate->(insertpage: (pdf_read:
		-file = $BkgPDF), 1);

	$pdfTemplate->(SetColor: 'stroke', 'CMYK', 0.93, 0.59, 0.33, 0.12);
	$pdfTemplate->(SetLineWidth: 0.25);


// Add fixed position text for first page to the PDF
	// Adding buyer info.
	$pdfTemplate->(Add:(
		PDF_Text:(($invoiceData->'buyerFirstName') + ' ' +
		($invoiceData->'buyerLastName') + '\r' +
		($invoiceData->'buyerOrgName') + '\r' +
		($invoiceData->'buyerOrgAddress') +
		(($invoiceData->'buyerCountry' != $defaultCountry) ? 
			('\r' + ($invoiceData->'buyerCountry')))
		), -Type='Paragraph', 
		-Font = $plainFont),
		-left = $buyerPos->(Get:1), 
		-top = $buyerPos->(Get:2),
		-width = $buyerPos->(Get:3),
		-height = $buyerPos->(Get:4),
		-align = 'left', 
		-leading = $textLeading);

	// Adding supplier info.
	$pdfTemplate->(Add:(
		PDF_Text:(($invoiceData->'supplierOrgName') + '\r' +
		($invoiceData->'supplierOrgAddress') +
		(($invoiceData->'supplierCountry' != $defaultCountry) ? 
			('\r' + ($invoiceData->'supplierCountry')))
		), -Type='Paragraph', 
		-Font = $plainFont),
		-left = $supplierPos->(Get:1), 
		-top = $supplierPos->(Get:2),
		-width = $supplierPos->(Get:3),
		-height = $supplierPos->(Get:4),
		-align = 'left', 
		-leading = $textLeading);

	// Adding invoice date.
	$pdfTemplate->(Add:(
		PDF_Text:$invoiceData->'invoiceDate', -Type='Paragraph', 
		-Font = $plainFont),
		-left = $datePos->(Get:1), 
		-top = $datePos->(Get:2),
		-width = $datePos->(Get:3),
		-height = $datePos->(Get:4),
		-align = 'left', 
		-leading = $textLeading);

	// Adding our ref name.
	$pdfTemplate->(Add:(
		PDF_Text:$invoiceData->'ourRef', -Type='Paragraph', 
		-Font = $plainFont),
		-left = $refPos->(Get:1), 
		-top = $refPos->(Get:2),
		-width = $refPos->(Get:3),
		-height = $refPos->(Get:4),
		-align = 'left', 
		-leading = $textLeading);

	// Adding invoice number.
	$pdfTemplate->(Add:(
		PDF_Text:$invoiceData->'invoiceNo', -Type='Paragraph', 
		-Font = $plainFont),
		-left = $invNoPos->(Get:1), 
		-top = $invNoPos->(Get:2),
		-width = $invNoPos->(Get:3),
		-height = $invNoPos->(Get:4),
		-align = 'left', 
		-leading = $textLeading);

	// Adding sum for all items.
	$pdfTemplate->(Add:(
		PDF_Text:$invoiceData->'sum', -Type='Paragraph', 
		-Font = $plainFont),
		-left = $sumPos->(Get:1), 
		-top = $sumPos->(Get:2),
		-width = $sumPos->(Get:3),
		-height = $sumPos->(Get:4),
		-align = 'right', 
		-leading = $textLeading);

	// Adding vat for all items.
	$pdfTemplate->(Add:(
		PDF_Text:$invoiceData->'vat', -Type='Paragraph', 
		-Font = $plainFont),
		-left = $vatPos->(Get:1), 
		-top = $vatPos->(Get:2),
		-width = $vatPos->(Get:3),
		-height = $vatPos->(Get:4),
		-align = 'right', 
		-leading = $textLeading);

	// Adding total cost for invoice.
	$pdfTemplate->(Add:(
		PDF_Text:$invoiceData->'total', -Type='Paragraph', 
		-Font = $plainFont),
		-left = $totalPos->(Get:1), 
		-top = $totalPos->(Get:2),
		-width = $totalPos->(Get:3),
		-height = $totalPos->(Get:4),
		-align = 'right', 
		-leading = $textLeading);

	// Adding note.
	$pdfTemplate->(Add:(
		PDF_Text:$invoiceData->'note', -Type='Paragraph', 
		-Font = $plainFont),
		-left = $notePos->(Get:1), 
		-top = $notePos->(Get:2),
		-width = $notePos->(Get:3),
		-height = $notePos->(Get:4),
		-align = 'left', 
		-leading = $textLeading);


	// Time to add invoice items.
	iterate: $invoiceData->'demoItems', $itemRaw;
		// First check the vertical space for the item name
		$itemTextContainer = $itemRaw->(Get:1)->(Split:'\r');

		$itemVerSize = $itemTextContainer->Size; // This gives us all hardcoded line feeds.
		iterate: $itemTextContainer, $tempContainer;
			// This adds rows if the content flows over more than one row.
			$itemVerSize += math_floor(($boldFont->(textwidth: $tempContainer)) / $col1Width);
		/iterate;

		// Then check the vertical space for the item description
		$itemTextContainer = $itemRaw->(Get:2)->(Split:'\r');

		$itemVerSize += $itemTextContainer->Size; // This gives us all hardcoded line feeds.
		iterate: $itemTextContainer, $tempContainer;
			// This adds rows if the content flows over more than one row.
			$itemVerSize += math_floor(($plainFont->(textwidth: $tempContainer)) / $col1Width);
		/iterate;
		$itemVerSize = $itemVerSize * $textLeading;

		if: $verSpace < ($itemVerSize + 18);
			$pdfTemplate->(Add:(PDF_Text:'Additional item specifications on following page!', -Type='Paragraph', 
				-Font = $boldFont),
				-left = $marginLeft + $col1Left, 
				-top = $itemTop,
				-width = $col1Width,
				-height = 30,
				-align = 'center', 
				-leading = $textLeading);

			//Resetting position vars.
			$verSpace = $verSpaceCont;
			$itemTop = $itemTopcont;
			$lineStart = $lineStartCont;

			// Insert the background pdf page.
			$pdfTemplate->(insertpage: (pdf_read:
				-file = $BkgPDF), 2, -NewPage='true');

			$pdfTemplate->(SetColor: 'stroke', 'CMYK', 0.93, 0.59, 0.33, 0.12);
			$pdfTemplate->(SetLineWidth: 0.25);

			// Adding invoice number.
			$pdfTemplate->(Add:(
				PDF_Text:$invoiceData->'invoiceNo', -Type='Paragraph', 
				-Font = $plainFont),
				-left = $invNoPos->(Get:1), 
				-top = $invNoPos->(Get:2),
				-width = $invNoPos->(Get:3),
				-height = $invNoPos->(Get:4),
				-align = 'left', 
				-leading = $textLeading);

			// Adding page number.
			$pdfTemplate->(Add:(
				PDF_Text:(string:($pdfTemplate->GetPageNumber)), -Type='Paragraph', 
				-Font = $plainFont),
				-left = $pageNoPos->(Get:1), 
				-top = $pageNoPos->(Get:2),
				-width = $pageNoPos->(Get:3),
				-height = $pageNoPos->(Get:4),
				-align = 'left', 
				-leading = $textLeading);

		/if;

		// Prepare the item text
		$itemText = (PDF_Text:$itemRaw->(Get:1) + '\r', -Type='Paragraph', 
				-Font = $boldFont);
		$itemText->(Add: (PDF_Text: $itemRaw->(Get:2),
					-Font=$plainFont));
		$pdfTemplate->(Add:$itemText,
			-left = $marginLeft + $col1Left, 
			-top = $itemTop,
			-width = $col1Width,
			-align = 'left', 
			-leading = $textLeading);

		$pdfTemplate->(Add:(PDF_Text:$itemRaw->(Get:3), -Type='Paragraph', 
				-Font = $plainFont),
			-left = $marginLeft + $col2Left, 
			-top = $itemTop,
			-width = $col2Width,
			-align = 'center', 
			-leading = $textLeading);

		$pdfTemplate->(Add:(PDF_Text:$itemRaw->(Get:4), -Type='Paragraph', 
				-Font = $plainFont),
			-left = $marginLeft + $col3Left, 
			-top = $itemTop,
			-width = $col3Width,
			-align = 'right', 
			-leading = $textLeading);

		$pdfTemplate->(Add:(PDF_Text:$itemRaw->(Get:5), -Type='Paragraph', 
				-Font = $plainFont),
			-left = $marginLeft + $col4Left, 
			-top = $itemTop,
			-width = $col4Width,
			-align = 'right', 
			-leading = $textLeading);

		$itemTop += $itemVerSize + $spaceBetween;
		$verSpace -= $itemVerSize + $spaceBetween;
		$lineStart -= $itemVerSize + $spaceBetween;
		$pdfTemplate->(Line: $marginLeft + 5, $lineStart + 6, ($marginLeft + $col4Left + $col4Width - 5), $lineStart + 6);


	/iterate;





// Serve the PDF.
	$pdfTemplate->close;
	pdf_serve: -content = $pdfTemplate, -file = 'Jina Demo Invoice.pdf';

?>